IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'PG_DEB_FORN_PG_DEB') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[PG_DEB_FORN_PG_DEB](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PG_DEB_LOTE] [int] NOT NULL,
	[CD_DEB_FORN] [int] NOT NULL,
	[CD_CRED_FORN] [int] NOT NULL,
	[VLR_LANC] [money] NOT NULL,
 CONSTRAINT [PK_PG_DEB_FORN_PG_DEB_1] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PG_DEB_LOTE] ASC,
	[CD_DEB_FORN] ASC,
	[CD_CRED_FORN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_DEB_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_DEB_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_DEB_CD_PG_CRED]  DEFAULT ((0)) FOR [CD_PG_DEB_LOTE]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_DEB_CD_DEB_FORN]  DEFAULT ((0)) FOR [CD_DEB_FORN]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] ADD  CONSTRAINT [DF_PG_DEB_FORN_PG_DEB_VLR_LANC]  DEFAULT ((0)) FOR [VLR_LANC]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_PG_DEB_PG_CRED_FORN] FOREIGN KEY([CD_EMP], [CD_CRED_FORN])
REFERENCES [dbo].[PG_CRED_FORN] ([CD_EMP], [CD_CRED_FORN])

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] CHECK CONSTRAINT [FK_PG_DEB_FORN_PG_DEB_PG_CRED_FORN]

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB]  WITH CHECK ADD  CONSTRAINT [FK_PG_DEB_FORN_PG_DEB_PG_DEB_FORN] FOREIGN KEY([CD_EMP], [CD_DEB_FORN])
REFERENCES [dbo].[PG_DEB_FORN] ([CD_EMP], [CD_DEB_FORN])

ALTER TABLE [dbo].[PG_DEB_FORN_PG_DEB] CHECK CONSTRAINT [FK_PG_DEB_FORN_PG_DEB_PG_DEB_FORN]
end